////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  ASEthernetInfoRetriever.h
//    This class is responsible retrieving the ethernet interfaces and getting the MAC address from it.
//
//  Copyright:  2009-2019 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//  02/28/29  R.E.A.  Added UniqueMACAddresses.
//  03/11/09  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "ASObject.h"

namespace ASFoundation
{
	class EXTERNAL_API ASEthernetInfoRetriever : public ASObject
	{
	public:
		enum 
		{
			kNoEthernetInterfacesFoundErrorId = 1,
			kNoMACAddressesFoundErrorId
		};
		
		static ASEthernetInfoRetriever* Create(void);
		virtual ~ASEthernetInfoRetriever(void);

		virtual CPString PrimaryMACAddress(void);

		virtual CPArray EthernetInterfaces(void) = 0;
		virtual CPString MACAddressForInterface(const CPObject& InternetInterface) = 0;
        virtual CPArray ListOfMACAddresses(void);
		
	protected:
		ASEthernetInfoRetriever(void);
	};
}
